import { Component, OnInit, Input } from '@angular/core';
import { PageSection } from '../../core/ui-config/page-section.model';
import { InputChanged } from '../../core/input-changed.model';
import { ChartContainerOptionsPageService } from '../../services/chart-container-options-page.service';
import { BehaviorSubject } from 'rxjs';
import { PortalService } from 'src/app/shared/components/portal';

@Component({
  selector: 'app-container-page-section',
  templateUrl: './container-page-section.component.html',
  styleUrls: ['./container-page-section.component.scss']
})
export class ContainerPageSectionComponent implements OnInit {
  @Input() section: PageSection;
  @Input() showSeparator: boolean;
  display$: BehaviorSubject<boolean>;

  constructor(
    public page: ChartContainerOptionsPageService,
    private portal: PortalService
  ) {
    this.display$ = new BehaviorSubject<boolean>(true);
  }

  ngOnInit() {
    this.page.refreshing$.subscribe((refreshing) => {
      this.portal.onShowLoading(refreshing);
      if (!refreshing) {
        this.persist();
      }
    });
  }

  updateSubOption(optionId: string, subOptionName: string, event: InputChanged): void {
    this.page.onSubOptionChanged(optionId, subOptionName, event.value, event.valueChanged);
  }

  persist() {
    this.display$.next(false);
    setTimeout(() => {
      this.display$.next(true);
    });
  }
}
