import { Component, OnInit } from '@angular/core';
import { UiConfig } from '../core/ui-config/ui-config.model';
import { Observable } from 'rxjs';
import { map, filter } from 'rxjs/operators';
import { environment } from 'src/environments/environment';
import { ChartContainerOptionService } from '../services/chart-container-option.service';
import { ChartContainerOptionsPageService } from '../services/chart-container-options-page.service';

@Component({
  selector: 'app-container-options-portal',
  templateUrl: './container-options-portal.component.html',
  styleUrls: ['./container-options-portal.component.scss'],
  providers: [ChartContainerOptionsPageService]
})
export class ContainerOptionsPortalComponent implements OnInit {
  uiConfig$: Observable<UiConfig>;
  manager$ = this.optionsService.manager$;
  showLoading$ = this.pageService.showLoading$;
  devMode: boolean;

  constructor(
    private optionsService: ChartContainerOptionService,
    private pageService: ChartContainerOptionsPageService
  ) {
    this.devMode = !environment.production;
    this.uiConfig$ = optionsService.manager$.pipe(
      filter(manager => manager !== null),
      map(manager => {
        if (manager.chartContainer.config) {
          return manager.chartContainer.config.ui;
        }
      }));
  }

  close(): void {
    this.optionsService.onClose();
  }

  ngOnInit() {
  }

  processAction(action: string): void {
    switch (action) {
      case 'refresh':
          this.pageService.refresh();
          break;
      default:
        break;
    }
  }
}
