import { Component, OnInit, Input, Output, EventEmitter, TemplateRef, ViewChild } from '@angular/core';
import { SidebarService } from 'src/app/shared/services/sidebar/sidebar.service';
import { Sidebar } from 'src/app/shared/services/sidebar/sidebar';
import { EngagementService } from '../services/engagement.service';
import { ChartContainerService } from 'projects/charts/src/app/services/chart-container.service';
import { Categories } from './engagement-categories';
import { AngularCsv } from 'angular7-csv/dist/Angular-csv'
import * as $ from 'jquery';
declare var UIkit: any;

@Component({
  selector: 'app-engagement',
  templateUrl: './engagement.component.html',
  styleUrls: ['./engagement.component.css']
})
export class EngagementComponent implements OnInit {
    engagementResults: any;
    currentPrincipalKey: number;
    dateRanges: any;
    showAllGraphs: boolean = false;
    principal: any = [];
    spinner: boolean = false;
    lastFetch: string = "";
    chartData: any = [];
    chartDataTitle: string = "";
    listDataArray: any = [];
    listDataFormatted: any = [];
    listTitle: string;
    currentCategory: string;
    currentCategoryName: string;
    categories = Categories;
    currentCategoryHasDateRanges: boolean = false;
    hasDateRangesSections: any = [];
    sidebarWidth: string = '0';
    showOverlay: boolean = false;
    @ViewChild('sidebar') sidebar: TemplateRef<any>;
    productUsageAllowed: boolean;
    productUsageDisallowedText: string;

    constructor(
        private engagementService: EngagementService,
        private sidebarService: SidebarService,
        private chartContainerService: ChartContainerService
    ) { }

    ngOnInit() {
        this.productUsageAccess();
        this.fetchEngagement();
    }

    private productUsageAccess() {
        var productUsageId = '11ea1c3faeproductusage399910d15e';
        this.chartContainerService.getChartContainerById(productUsageId).subscribe(chartContainer => {
            this.productUsageAllowed = chartContainer.config !== false ? true : false;
            this.productUsageDisallowedText = this.productUsageAllowed === false ? "You do not have access to this page" : "";
        });
    }

    public fetchEngagement(): void {
        this.principal.engagementScoreTotal = 0;
        this.principal.engagementScoreEarned = 0;
        this.principal.spinner = true;

        this.engagementService.getEngagement()
        .subscribe(response => {
            if (response['engagementInfo']) {
                this.engagementResults = response['engagementInfo'];
                this.principal.engagement = [];
                this.principal.engagement[0] = [];
                this.principal.engagement[1] = [];
                var key = 0;
                for (let i in this.engagementResults) {
                    var section = this.engagementResults[i].origin === "custom" ? 1 : 0;
                    if (this.engagementResults[i].type === "string" ||
                        this.engagementResults[i].type === "integer" ||
                        this.engagementResults[i].type === "multiselect" ||
                        this.engagementResults[i].type === "textarea" ||
                        this.engagementResults[i].type === "boolean" ||
                        this.engagementResults[i].type === "csvlist"
                    ) {
                        var value = this.engagementResults[i].value;
                        var valueClass = this.engagementResults[i].score === 0 ? "grey" : "gold";
                        var scoreDisplay = [];
                        var type = "string";
                        if (this.engagementResults[i].type == "boolean") {
                            value = this.engagementResults[i].value === false ? "No" : "Yes";
                            scoreDisplay = this.engagementResults[i].value === false ? ["cross"] : ["star"];
                            valueClass = this.engagementResults[i].value === false ? "grey" : "gold";
                            if (this.engagementResults[i].value === "0" || this.engagementResults[i].value === "1") {
                                value = this.engagementResults[i].value === "0" ? "No" : "Yes";
                                scoreDisplay = this.engagementResults[i].value === "0" ? ["cross"] : ["star"];
                                valueClass = this.engagementResults[i].value === "0" ? "grey" : "gold";
                            }                            
                        }
                        if (this.engagementResults[i].type == "integer") {
                            scoreDisplay = this.engagementResults[i].score === "1/1" ? ["star"] : ["nostar"];
                        }
                        if (this.engagementResults[i].type == "string") {
                            value = value.replace(/\n/gi, "<br />");
                            switch(this.engagementResults[i].score) {
                            case "0/3":
                                scoreDisplay = ["nostar","nostar","nostar"];
                                break;
                            case "1/3":
                                scoreDisplay = ["star","nostar","nostar"];
                                break;
                            case "2/3":
                                scoreDisplay = ["star","star","nostar"];
                                break;
                            case "3/3":
                                scoreDisplay = ["star","star","star"];
                                break;
                            case "0/2":
                                scoreDisplay = ["nostar"];
                                break;
                            case "1/2":
                                scoreDisplay = ["star","nostar"];
                                break;
                            case "2/2":
                                scoreDisplay = ["star","star"];
                                break;
                            }
                        }
                        if (this.engagementResults[i].type == "csvlist") {
                            if (value !== '') {
                                var values = value.split(',');
                                value = values.length;
                            } else {
                                value = '0';
                            }
                            type = "csvlist";
                        }
                        var score = this.engagementResults[i].score === "0/0" ? "N/A" : this.engagementResults[i].score;
                        var overline = this.engagementResults[i].overline === "1" ? true : false;
                        var underline = this.engagementResults[i].underline === "1" ? true : false;
                        var box = this.engagementResults[i].box === "1" ? true : false;
                        this.principal.engagement[section].push({
                            type: type,
                            displayFormat: this.engagementResults[i].displayFormat,
                            label: this.engagementResults[i].caption,
                            value: value,
                            rawValue: this.engagementResults[i].value,
                            class: valueClass,
                            score: score,
                            scoreDisplay: scoreDisplay,
                            desc: this.engagementResults[i].desc,
                            key: key,
                            fieldId: this.engagementResults[i].fieldId ? this.engagementResults[i].fieldId : '',
                            border: this.engagementResults[i].border,
                            learnOnline: this.engagementResults[i].learnOnline,
                            category: this.engagementResults[i].category
                        });
                        key++;
                    }

                    if (this.engagementResults[i].type === "graph") {
                        var valueClass = "";
                        switch(this.engagementResults[i].score) {
                        case "0/3":
                            valueClass = "red";
                            scoreDisplay = ["nostar","nostar","nostar"];
                            break;
                        case "1/3":
                            valueClass = "orange";
                            scoreDisplay = ["star","nostar","nostar"];
                            break;
                        case "2/3":
                            valueClass = "orange";
                            scoreDisplay = ["star","star","nostar"];
                            break;
                        case "3/3":
                            valueClass = "green";
                            scoreDisplay = ["star","star","star"];
                            break;
                        }
                        this.principal.engagement[section].push({
                            type: "chart",
                            label: this.engagementResults[i].caption,
                            chart: this.createChart(
                                this.engagementResults[i].caption,
                                "Total: " + this.engagementResults[i].total,
                                this.engagementResults[i].chartYAxis,
                                this.engagementResults[i].months
                            ),
                            value: this.engagementResults[i].score === "0/3" ? "No" : "Yes",
                            class: valueClass,
                            score: this.engagementResults[i].score,
                            scoreDisplay: scoreDisplay,
                            showGraph: false,
                            desc: this.engagementResults[i].desc,
                            key: key,
                            fieldId: this.engagementResults[i].fieldId ? this.engagementResults[i].fieldId : '',
                            learnOnline: this.engagementResults[i].learnOnline,
                            category: this.engagementResults[i].category
                        });
                        this.hasDateRangesSections.push(this.engagementResults[i].category);
                        key++;
                    }

                    if (this.engagementResults[i].type === "dateranges") {
                        this.dateRanges = [
                            {value: "Q1: " + this.engagementResults[i].ranges.months3 + " to " + this.engagementResults[i].ranges.now},
                            {value: "Q2: " + this.engagementResults[i].ranges.months6 + " to " + this.engagementResults[i].ranges.months3},
                            {value: "Q3: " + this.engagementResults[i].ranges.months9 + " to " + this.engagementResults[i].ranges.months6},
                            {value: "Q4: " + this.engagementResults[i].ranges.months12 + " to " + this.engagementResults[i].ranges.months9},
                            {value: "Q5: " + this.engagementResults[i].ranges.months15 + " to " + this.engagementResults[i].ranges.months12},
                            {value: "Q6: " + this.engagementResults[i].ranges.months18 + " to " + this.engagementResults[i].ranges.months15},
                            {value: "Q7: " + this.engagementResults[i].ranges.months21 + " to " + this.engagementResults[i].ranges.months18},
                            {value: "Q8: " + this.engagementResults[i].ranges.months24 + " to " + this.engagementResults[i].ranges.months21}
                        ]
                    }

                    if (this.engagementResults[i].type === "special") {
                        if (this.engagementResults[i].name === "lastFetch") {
                            this.lastFetch = this.engagementResults[i].value;
                        }
                    }

                    if (typeof this.engagementResults[i].score !== "undefined" && this.engagementResults[i].score !== null) {
                        var score = this.engagementResults[i].score.split("/");
                        this.principal.engagementScoreTotal += parseInt(score[1]);
                        this.principal.engagementScoreEarned += parseInt(score[0]);
                        this.principal.engagementScorePercentage = Math.round(100 / this.principal.engagementScoreTotal * this.principal.engagementScoreEarned);
                    }
                }

            }

            this.principal.spinner = false;
            this.principal.engagementScoreChart = {
                chart: {
                    showLabels: false,
                    showValues: false,
                    startingAngle: 90,
                    chartLeftMargin: 0,
                    chartRightMargin: 0,
                    chartTopMargin: 0,
                    chartBottomMargin: 0,
                    numberSuffix: "",
                    theme: "fusion"
                },
                data: [
                    {
                        "color": "#333",
                        "hoverColor": "#333",
                        "alpha": "25",
                        "hoverAlpha": "25",
                        "value": this.principal.engagementScoreTotal - this.principal.engagementScoreEarned
                    },
                    {
                        "color": "#00FF00",
                        "value": this.principal.engagementScoreEarned
                    }
                ]
            };

            this.principal.engagementScoreChart = {
                chart: {
                    lowerlimit: "0",
                    upperlimit: "100",
                    showvalue: "1",
                    numbersuffix: "%",
                    theme: "fusion",
                    showtooltip: "0",
                    chartLeftMargin: 0,
                    chartRightMargin: 0,
                    chartTopMargin: 0,
                    chartBottomMargin: 0,
                    showBorder: 0,
                    bgColor: "#fff",
                    bgAlpha: "0",
                    canvasbgAlpha: "0"
                },
                colorrange: {
                    color: [
                    {
                        minvalue: "0",
                        maxvalue: "40",
                        code: "#F2726F"
                    },
                    {
                        minvalue: "40",
                        maxvalue: "75",
                        code: "#FFC533"
                    },
                    {
                        minvalue: "75",
                        maxvalue: "100",
                        code: "#62B58F"
                    }
                    ]
                },
                dials: {
                    dial: [
                        {
                            value: this.principal.engagementScorePercentage
                        }
                    ]
                }
            };
        });
    }

    public createChart(chartCaption: string, chartSubCaption: string, chartYAxisName: string, months: any): any {
        var chart = {
          chart: {
            caption: chartCaption,
            subCaption: chartSubCaption,
            xAxisName: "Quarters",
            yAxisName: chartYAxisName,
            numberSuffix: "",
            theme: "fusion"
          },
          data: []
        };

        var quarter = 1;
        for(let i in months){
            chart.data.push({
                label: "Q" + quarter,
                value: months[i],
                toolText: "<strong>" + months[i] + "</strong> for " + this.dateRanges[quarter-1].value
            });
            quarter++;
        }
        chart.data.reverse();
        
        return chart;
    }

    public showGraph(key: number): void {
        for (let i in this.principal.engagement[0]) {
            if (this.principal.engagement[0][i].key === key) {
                this.chartData = this.principal.engagement[0][i].chart;
                this.chartDataTitle = this.principal.engagement[0][i].label;
            }
        }
        UIkit.modal(`#modalGraph`).show();
    }

    public showList(key: number): void {
        this.listDataArray = [];
        delete this.listDataFormatted;
        for (let i in this.principal.engagement[0]) {
            if (this.principal.engagement[0][i].key === key) {
                if (this.principal.engagement[0][i].displayFormat == "table") {
                    var output = '<table id="listTable" width="100%"><tr>';
                    var rows = this.principal.engagement[0][i].rawValue.split("\\n");
                    for (let x in rows) {
                        var row = rows[x].split(/,(?=(?:(?:[^"]*"){2})*[^"]*$)/);
                        for (let a in row) {
                            row[a] = row[a].replace(/^"(.*)"$/, '$1');
                        }
                        if (x === '0') {
                            output += '<td class="head" width="50%">' + row.join('</td><td class="head" width="50%">') + '</td></tr>';
                        } else {
                            output += '<tr><td>' + row.join('</td><td>') + '</td></tr>';
                        }
                        this.listDataArray.push({
                            name: row[0],
                            time: row[1],
                        });
                    }
                } else {
                    this.listDataFormatted = this.principal.engagement[0][i].rawValue.replace(/,/gi, "<br />");
                }
                
                this.listTitle = this.principal.engagement[0][i].label;
            }
        }
        UIkit.modal(`#modalList`).show();
    }

    public learnOnline(url: string): void {
        window.open(url, '_blank')
    }

    public exportCSV(): void {
        var csvOptions = {
            fieldSeparator: ',',
            quoteStrings: '"',
            decimalseparator: '.',
            showLabels: true,
            showTitle: true,
            title: 'ResRequest Client Engagement',
            useBom: true,
            noDownload: false
        };

        var csvData = [];

        csvData.push({
            name: 'Total Score: ' + this.principal.engagementScorePercentage + '% (' + this.principal.engagementScoreEarned + '/' + this.principal.engagementScoreTotal + ')'
        });

        var monthName = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
        var date = new Date();
        var reportDate = date.getDate() + ' ' + monthName[date.getMonth()] + ' ' + date.getFullYear() + ', ' + ('0' + date.getHours()).slice(-2) + ':' + ('0' + date.getMinutes()).slice(-2);
        csvData.push({
            name: 'Date: ' + reportDate
        });

        csvData.push({
            name: ''
        });

        csvData.push({
            name: 'Name',
            value: 'Value',
            score: 'Score',
            description: 'Description'
        });

        for (let x in this.principal.engagement) {
            for (let i in this.principal.engagement[x]) {
                csvData.push({
                    name: this.principal.engagement[x][i].label,
                    value: this.principal.engagement[x][i].value,
                    score: this.principal.engagement[x][i].score,
                    description: this.principal.engagement[x][i].desc
                });
            }
        }

        new  AngularCsv(csvData, 'ResRequest Client Engagement', csvOptions);
    }

    public selectCat(abbr): void {
        this.currentCategory = abbr;
        for (let i in this.categories) {
            if (abbr != 'all' && this.categories[i].abbr == abbr) {
                this.currentCategoryName = this.categories[i].caption;
            }
        }
        this.currentCategoryHasDateRanges = false;
        for (let i in this.hasDateRangesSections) {
            if (abbr === 'all' || this.hasDateRangesSections[i] == abbr) {
                this.currentCategoryHasDateRanges = true;
            }
        }
    }

    public showCategories(): void {
        delete this.currentCategory;
        delete this.currentCategoryName;
    }

    public toggleSidePanel(): void {
        if (this.sidebarWidth != '0') {
            this.sidebarWidth = '0';
            this.showOverlay = false;
        } else {
            this.sidebarWidth = '300';
            this.showOverlay = true;
        }
    }

  private openSidenav(id: string, template: TemplateRef<any>): void {
    const sidebar: Sidebar = {
      id,
      template
    };
    this.sidebarService.showSidebar(sidebar);
  }

  public openSidebar(): void {
    this.openSidenav('engagement-sidenav', this.sidebar);
  }

  public closeSidebar():void {
    this.sidebarService.close();
  }

}
