import { Pipe, PipeTransform } from '@angular/core';

@Pipe({
  name: 'engagementCards'
})
export class EngagementCardsPipe implements PipeTransform {

    transform(items: any[], currentCategory: string, category: string): any[] {
        if (!items) { return []; }
        if (!currentCategory) { return []; }
        if (currentCategory == "all") { return items; }

        return items.filter(item => {
            if (item && item[category] && item[category] === currentCategory) {
                return item[category];
            }
            return false;
        });
    }

}
