import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { Property } from 'src/app/shared/components/accommodation-filter/accommodation-filter.component';
import { InputChanged } from '../../core/input-changed.model';

@Component({
  selector: 'app-accommodation-filter-input',
  templateUrl: './accommodation-filter-input.component.html',
  styleUrls: ['./accommodation-filter-input.component.scss']
})
export class AccommodationFilterInputComponent implements OnInit {
  @Input() config: Property[];
  @Input() value: string[];
  @Output() valueChanged: EventEmitter<InputChanged>;

  protected initialValue: string[];

  constructor() {
    this.config = [];
    this.value = [];
    this.initialValue = [];
    this.valueChanged = new EventEmitter<InputChanged>();
  }

  ngOnInit() {
    this.initialValue = this.value;
  }

  hasValueChanged(value) {
    let valueChanged = false;
    const accommodations = this.initialValue;

    if (value.length !== accommodations.length) {
      valueChanged = true;
    } else {
      value.forEach(accommodation => {
        const index = accommodations.indexOf(accommodation);

        if (index < 0) {
          valueChanged = true;
        }
      });
    }

    return valueChanged;
  }

  onChange(value: string[]): void {
    const valueChanged = this.hasValueChanged(value);

    const inputChanged: InputChanged = {
      value,
      valueChanged
    };

    this.valueChanged.emit(inputChanged);
  }
}
