import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { InputChanged } from '../../core/input-changed.model';

@Component({
  selector: 'app-button-toggle',
  templateUrl: './button-toggle.component.html',
  styleUrls: ['./button-toggle.component.scss']
})
export class ButtonToggleComponent implements OnInit {
  @Input() config: any;
  @Input() value: string;

  @Output() valueChanged: EventEmitter<InputChanged>;

  private initialValue: string;

  constructor() {
    this.valueChanged = new EventEmitter();
  }

  ngOnInit() {
    this.initialValue = this.value;
  }

  toggleChange() {
    let valueChanged = true;

    if (this.initialValue === this.value) {
      valueChanged = false;
    }

    const inputChanged: InputChanged = {
      value: this.value,
      valueChanged
    };

    this.valueChanged.emit(inputChanged);
  }

}
