import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { FormControl } from '@angular/forms';

@Component({
  selector: 'app-calendar',
  templateUrl: './calendar.component.html',
  styleUrls: ['./calendar.component.scss']
})
export class CalendarComponent implements OnInit {
  @Input() option;
  @Output() optionValueChanged: EventEmitter<string[]>;

  date = new FormControl(new Date());
  placeholder = ''; // Placeholder text for datepicker input

  constructor() {
    this.optionValueChanged = new EventEmitter();
  }

  ngOnInit() {
    this.date = new FormControl(new Date(this.option.value));
    this.placeholder = this.option.placeholder;
  }

  dateChanged(date) {
    this.optionValueChanged.emit(date.format());
  }
}
