import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import * as moment from 'moment';
import { InputChanged } from '../../core/input-changed.model';

interface DateRangeValue {
  startDate: string;
  endDate: string;
}

@Component({
  selector: 'app-date-range',
  templateUrl: './date-range.component.html',
  styleUrls: ['./date-range.component.scss']
})
export class DateRangeComponent implements OnInit {
  @Input() config;
  @Input() value: DateRangeValue;

  @Output() valueChanged: EventEmitter<InputChanged>;

  initialStartDate: moment.Moment;
  initialEndDate: moment.Moment;
  startDate: moment.Moment;
  endDate: moment.Moment;

  constructor() {
    this.valueChanged = new EventEmitter();
  }

  ngOnInit() {
    this.initialStartDate = moment(this.value.startDate);
    this.initialEndDate = moment(this.value.endDate);

    this.startDate = moment(this.initialStartDate);
    this.endDate = moment(this.initialEndDate);
  }

  onValueChange() {
    let valueChanged = true;
    if (this.startDate.isSame(this.initialStartDate, 'day') && this.endDate.isSame(this.initialEndDate, 'day')) {
      valueChanged = false;
    }

    const startDate = this.startDate.toString();
    const endDate = this.endDate.toString();

    const value = {
      startDate,
      endDate
    };

    const inputChanged: InputChanged = {
      value,
      valueChanged
    };

    this.valueChanged.emit(inputChanged);
  }


}
