import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';

@Component({
  selector: 'app-multiselect-dropdown',
  templateUrl: './multiselect-dropdown.component.html',
  styleUrls: ['./multiselect-dropdown.component.scss']
})
export class MultiselectDropdownComponent implements OnInit {
  @Input() option;
  selectedValues = [];

  @Output() optionValueChanged: EventEmitter<string[]>;

  constructor() {
    this.optionValueChanged = new EventEmitter();
  }

  ngOnInit() {
    this.selectedValues = this.option.value;
  }

  valueChanged() {
    this.optionValueChanged.emit(this.selectedValues);
  }
}
