import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { InputChanged } from '../../core/input-changed.model';

@Component({
  selector: 'app-option-input',
  templateUrl: './option-input.component.html',
  styleUrls: ['./option-input.component.scss']
})
export class OptionInputComponent implements OnInit {
  @Input() type: string;
  @Input() value: any;
  @Input() config: any;
  @Output() valueChanged: EventEmitter<any>;

  constructor() {
    this.valueChanged = new EventEmitter<any>();
  }

  ngOnInit() {
  }

  onValueChanged(inputChanged: InputChanged): void {
    this.valueChanged.emit(inputChanged);
  }
}
