import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { InputChanged } from '../../core/input-changed.model';
import { SplitInterpolation } from '@angular/compiler';

@Component({
  selector: 'app-radio-group',
  templateUrl: './radio-group.component.html',
  styleUrls: ['./radio-group.component.scss']
})
export class RadioGroupComponent implements OnInit {
  @Input() config: any;
  @Input() value: string;

  @Output() valueChanged: EventEmitter<InputChanged>;

  private initialValue: string;

  constructor() {
    this.valueChanged = new EventEmitter();
  }

  ngOnInit() {
    this.initialValue = this.value;
  }

  radioChange() {
    let valueChanged = true;

    if (this.initialValue === this.value) {
      valueChanged = false;
    }

    const inputChanged: InputChanged = {
      value: this.value,
      valueChanged
    };

    this.valueChanged.emit(inputChanged);
  }

}
