import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { InputChanged } from '../../core/input-changed.model';

@Component({
  selector: 'app-slider-toggle',
  templateUrl: './slider-toggle.component.html',
  styleUrls: ['./slider-toggle.component.scss']
})
export class SliderToggleComponent implements OnInit {
  @Input() config: any;
  @Input() value: string;

  @Output() valueChanged: EventEmitter<InputChanged>;

  private initialValue: string;

  constructor() {
    this.valueChanged = new EventEmitter();
  }

  ngOnInit() {
    this.initialValue = this.value;
  }

  toggleChange() {
    let valueChanged = false;

    if (this.initialValue !== this.value) {
      valueChanged = true;
    }

    const inputChanged: InputChanged = {
      value: this.value,
      valueChanged
    };

    this.valueChanged.emit(inputChanged);
  }

}
