import { Component, OnInit, Input } from '@angular/core';
import { OptionsPageService } from '../services/options-page.service';
import { Observable } from 'rxjs';
import { PageSection } from '../core/ui-config/page-section.model';
import { map } from 'rxjs/operators';

@Component({
  selector: 'app-options-page',
  templateUrl: './options-page.component.html',
  styleUrls: ['./options-page.component.scss'],
  providers: []
})
export class OptionsPageComponent implements OnInit {
  @Input() name: string;

  optionsChanged$ = this.pageService.optionsChanged$;
  sections$: Observable<PageSection[]>;

  constructor(private pageService: OptionsPageService) { }

  ngOnInit() {
    this.sections$ = this.pageService.pageToSections$.pipe(
      map(pageToSections => {
        // Force a rerender by changing references.
        const sections = pageToSections[this.name];
        const newSections = sections.map(section => ({...section}));
        return newSections;
      })
    );
  }

  clear(): void {
    this.pageService.reset();
  }

  apply(): void {
    this.pageService.apply();
  }

}
