import { Component, OnInit, Input } from '@angular/core';
import { PageSection } from '../../core/ui-config/page-section.model';
import { OptionsPageService } from '../../services/options-page.service';
import { InputChanged } from '../../core/input-changed.model';

@Component({
  selector: 'app-page-section',
  templateUrl: './page-section.component.html',
  styleUrls: ['./page-section.component.scss']
})
export class PageSectionComponent implements OnInit {
  @Input() section: PageSection;
  @Input() showSeparator: boolean;

  constructor(public page: OptionsPageService) { }

  ngOnInit() {
  }

  updateSubOption(optionId: string, subOptionName: string, event: InputChanged): void {
    this.page.onSubOptionChanged(optionId, subOptionName, event.value, event.valueChanged);
  }
}
