import { Component, OnInit } from '@angular/core';
import { OptionService } from '../services/option.service';
import { UiConfig } from '../core/ui-config/ui-config.model';
import { Observable } from 'rxjs';
import { map, filter } from 'rxjs/operators';
import { OptionsPageService } from '../services/options-page.service';
import { environment } from 'src/environments/environment';

@Component({
  selector: 'app-options-portal',
  templateUrl: './options-portal.component.html',
  styleUrls: ['./options-portal.component.scss'],
  providers: [OptionsPageService]
})
export class OptionsPortalComponent implements OnInit {
  uiConfig$: Observable<UiConfig>;
  manager$ = this.optionsService.manager$;
  showLoading$ = this.pageService.showLoading$;
  devMode: boolean;

  constructor(
    private optionsService: OptionService,
    private pageService: OptionsPageService
  ) {
    this.devMode = !environment.production;
    this.uiConfig$ = optionsService.manager$.pipe(
      filter(manager => manager !== null),
      map(manager => {
        return manager.chart.config.ui;
      }));
  }

  close(): void {
    this.optionsService.onClose();
  }

  ngOnInit() {
  }

  processAction(action: string): void {
    switch (action) {
      case 'refresh':
          this.pageService.refresh();
          break;
      default:
        break;
    }
  }
}
