import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { first } from 'rxjs/operators';
import { SidebarService } from 'src/app/shared/services/sidebar/sidebar.service';
import { Sidebar } from 'src/app/shared/services/sidebar/sidebar';
import { ChartContainerManager } from '../core/chart-container-manager';

@Injectable()
export class ChartContainerOptionService {
  private managerSource: BehaviorSubject<ChartContainerManager>;
  manager$: Observable<ChartContainerManager>;

  constructor(private sidebarService: SidebarService) {
    this.managerSource = new BehaviorSubject<ChartContainerManager>(null);
    this.manager$ = this.managerSource.asObservable();
  }

  onShowOptions(manager: ChartContainerManager, sidebar: Sidebar): void {
    this.manager$.pipe(first()).subscribe(currentManager => {
      if (currentManager !== manager) {
        this.managerSource.next(manager);
      }

      this.sidebarService.showSidebar(sidebar);
    });
  }

  onClose(): void {
    this.sidebarService.close();
  }

  refresh(): void {
    this.manager$.pipe(first()).subscribe(manager => {
      this.managerSource.next(manager);
    });
  }
}
