import { Injectable } from '@angular/core';
import { Observable, of} from 'rxjs';
import { catchError, map, tap } from 'rxjs/operators';

import { ChartContainer } from '../core/chart-container.model';
import { RcmApiService } from 'resrequest-angular-common';

@Injectable({
  providedIn: 'root'
})
export class ChartContainerService {
  chartUrl = '/chart-container';

  constructor(private api: RcmApiService) { }

  public getChartContainerById(id: string): Observable<ChartContainer> {
    const url = `${this.chartUrl}/${id}`;

    return this.api.get(url).pipe(
      catchError(this.handleError<ChartContainer>(`Failed to get chart container id: "${id}"`))
    );
  }

  /**
   * Handle Http operation that failed.
   * Let the app continue.
   * @param operation - name of the operation that failed
   * @param result - optional value to return as the observable result
   */
  private handleError<T>(operation = 'operation', result?: T) {
    return (error: any): Observable<T> => {
      console.error(error); // log to console instead
      return of(result as T);
    };
  }
}
