import { Injectable } from '@angular/core';
import { Observable, of} from 'rxjs';
import { catchError } from 'rxjs/operators';

import { ChartResponse } from '../core/chart-response.model';
import { RcmApiService } from 'resrequest-angular-common';
import { Chart } from '../core/chart.model';

@Injectable()
export class ChartService {
  chartUrl = '/chart';

  constructor(private api: RcmApiService) { }

  public getChartById(id: string): Observable<ChartResponse> {
    const url = `${this.chartUrl}/${id}`;

    return this.api.get(url).pipe(
      catchError(this.handleError<ChartResponse>(`Failed to get chart id: "${id}"`))
    );
  }

  public buildChart(chart: Chart, optionValues = []): Observable<ChartResponse> {
    const url = `/api/v1/chart-builder`;
    return this.api.post(url, {chart, optionValues}).pipe(
      catchError(error => {
        console.log(error);
        return of(null);
      })
    );
  }

  /**
   * Handle Http operation that failed.
   * Let the app continue.
   * @param operation - name of the operation that failed
   * @param result - optional value to return as the observable result
   */
  private handleError<T>(operation = 'operation', result?: T) {
    return (error: any): Observable<T> => {
      console.error(error); // log to console instead
      return of(result as T);
    };
  }
}
