import { Injectable } from '@angular/core';
import { Observable, of} from 'rxjs';
import { catchError } from 'rxjs/operators';
import { RcmApiService } from 'resrequest-angular-common';

@Injectable({
  providedIn: 'root'
})
export class EngagementService {

    constructor(private api: RcmApiService) { }

    public getEngagement(): any {
        const url = `/api/v1/systeminfo`;
        return this.api.post(url, {data: 'engagementInfo'}).pipe(
          catchError(error => {
            console.log(error);
            return of(null);
          })
        );
    }
}
