import { Injectable } from '@angular/core';
import { BehaviorSubject, Observable } from 'rxjs';
import { ChartManager } from '../core/chart-manager';
import { first } from 'rxjs/operators';
import { SidebarService } from 'src/app/shared/services/sidebar/sidebar.service';
import { Sidebar } from 'src/app/shared/services/sidebar/sidebar';

@Injectable()
export class OptionService {
  private managerSource: BehaviorSubject<ChartManager>;
  manager$: Observable<ChartManager>;

  constructor(private sidebarService: SidebarService) {
    this.managerSource = new BehaviorSubject<ChartManager>(null);
    this.manager$ = this.managerSource.asObservable();
  }

  onShowOptions(manager: ChartManager, sidebar: Sidebar): void {
    this.manager$.pipe(first()).subscribe(currentManager => {
      if (currentManager !== manager) {
        this.managerSource.next(manager);
      }

      this.sidebarService.showSidebar(sidebar);
    });
  }

  onClose(): void {
    this.sidebarService.close();
  }

  refresh(): void {
    this.manager$.pipe(first()).subscribe(manager => {
      this.managerSource.next(manager);
    });
  }
}
