import { Component } from '@angular/core';
import { trigger, state, style, animate, transition } from '@angular/animations';

@Component({
  selector: 'app-settings-button',
  templateUrl: './settings-button.component.html',
  styleUrls: ['./settings-button.component.scss'],
  animations: [
    trigger('rotateCog', [
      state('initial', style({
        transform: 'rotate(0)'
      })),
      state('final', style({
        transform: 'rotate(360deg)'
      })),
      transition('initial=>final', animate('800ms ease-out')),
      transition('final=>initial', animate('0ms'))
    ]),
  ]
})
export class SettingsButtonComponent {
  state = 'initial';

  constructor() {}

  rotate() {
    this.state = 'final';
  }
}
