import { NgModule } from '@angular/core';
import { RouterModule, Routes } from '@angular/router';
import { MenuComponent } from './menu/menu.component';

const GuestRoutes: Routes = [
  { path: '', component: MenuComponent },
  { path: 'check-in', loadChildren: () => import('./checkin/checkin.module').then(m => m.CheckInModule) },
  { path: 'list', loadChildren: () => import('./list/list.module').then(m => m.GuestListModule) },
  { path: '**', redirectTo: '' }
];

@NgModule({
  imports: [
    RouterModule.forRoot(GuestRoutes)
  ],
  exports: [
    RouterModule
  ]
})
export class AppRoutingModule { }
