import { NgModule } from '@angular/core';
import { AppComponent } from './app.component';
import { AppRoutingModule } from './app-routing.module';
import { MatTabsModule } from '@angular/material/tabs';
import { CdkStepperModule } from '@angular/cdk/stepper';
import { MatStepperModule } from '@angular/material/stepper';
import { SharedGuestModule } from './shared/shared-guest.module';
import { MatIconModule } from '@angular/material/icon';
import { BrowserModule  } from '@angular/platform-browser';
import { MenuComponent } from './menu/menu.component';
import { HttpClientModule } from '@angular/common/http';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { GuestService } from './shared/services/guest/guest.service';

@NgModule({
  declarations: [AppComponent, MenuComponent],
  providers: [GuestService],
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    AppRoutingModule,
    MatTabsModule,
    CdkStepperModule,
    MatStepperModule,
    SharedGuestModule,
    MatIconModule,
    HttpClientModule,
  ],
  bootstrap: [ AppComponent ]
})
export class AppModule { }
