import { Component, ViewChild } from '@angular/core';
import { CheckReservationComponent } from "../shared/components/forms/check-reservation/check-reservation.component";
import { CheckInService } from '../shared/services/check-in/checkin.service';
import { animate, style, transition, trigger } from '@angular/animations';


@Component({
  selector: 'app-guest-checkin',
  templateUrl: './checkin.component.html',
  styleUrls: ['./checkin.component.scss'],
  providers: [
    CheckInService
  ],
  animations: [
    trigger(
      'fadeOutAnimation',
      [
        transition(
          ':leave',
          [
            style({ opacity: 1 }),
            animate('500ms ease-in',
              style({ opacity: 0 }))
          ]
        )
      ]
    )
  ]
})
export class CheckInComponent {
  @ViewChild('checkReservation', {static: false}) checkReservation: CheckReservationComponent;

  step$ = this.checkInService.step$;
  item$ = this.checkInService.item$;
  items$ = this.checkInService.items$;
  guest$ = this.checkInService.guest$;
  guests$ = this.checkInService.guests$;
  error$ = this.checkInService.error$;
  guestSettings$ = this.checkInService.guestSettings$;
  loading$ = this.checkInService.loading$;

  constructor(private checkInService: CheckInService) { }

  onCheckReservation(reservationRequest) {
    this.checkInService.setReservation(reservationRequest).then(success => {
      if (this.checkReservation) {
        this.checkReservation.enableForm();
      }
    });
  }

  onGuestSelect(guest) {
    this.checkInService.setGuest(guest);
  }

  onItemSelect(item) {
    this.checkInService.setItem(item);
  }

  getGuestsByItem(item) {
    return this.checkInService.getGuestsByItem(item);
  }

  reset() {
    this.checkInService.reset();
  }

  clearItem() {
    this.checkInService.clearItem();
  }
}
