import { animate, style, transition, trigger } from '@angular/animations';
import { Component, OnInit, ViewChild } from '@angular/core';
import { CheckReservationComponent } from '../shared/components/forms/check-reservation/check-reservation.component';
import { GuestListService } from '../shared/services/guest-list/guest-list.service';


@Component({
  selector: 'app-guest-list',
  templateUrl: './list.component.html',
  styleUrls: ['./list.component.scss'],
  providers: [
    GuestListService
  ],
  animations: [
    trigger(
      'fadeOutAnimation',
      [
        transition(
          ':leave',
          [
            style({ opacity: 1 }),
            animate('500ms ease-in',
              style({ opacity: 0 }))
          ]
        )
      ]
    )
  ]
})
export class GuestListComponent implements OnInit {
  @ViewChild('checkReservation', {static: false}) checkReservation: CheckReservationComponent;

  loading$ = this.listService.loading$;
  error$ = this.listService.error$;
  step$ = this.listService.step$;
  guestSettings$ = this.listService.guestSettings$;

  constructor(private listService: GuestListService) { }

  ngOnInit() {

    this.setDocumentTitle();
  }

  onCheckReservation(reservationRequest) {
    this.listService.setReservation(reservationRequest).then(success => {
      this.checkReservation.enableForm();
    });
  }

  setDocumentTitle() {
  }

}
