import { Component, OnInit } from '@angular/core';


@Component({
  selector: 'app-button-container',
  templateUrl: './button-container.component.html',
  styleUrls: ['./button-container.component.scss']
})
export class ButtonContainerComponent implements OnInit {
  iconFontLoaded: boolean = false;

  ngOnInit(): void {
    this.checkIconFontLoaded();
  }

  private checkIconFontLoaded(): void {
    if ((document as any).fonts.check('1em Material Icons')) {
      setTimeout(() => {
        this.iconFontLoaded = true;
      }, 100);
    } else {
      setTimeout(() => {
        this.checkIconFontLoaded();
      }, 100);
    }
  }
}
