import { Component, EventEmitter, Input, OnInit, Output, ElementRef } from '@angular/core';
import { FormBuilder, FormGroup } from '@angular/forms';
import { GuestService } from '../../../services/guest/guest.service';
import { Router } from '@angular/router';

@Component({
  selector: 'app-check-reservation',
  templateUrl: './check-reservation.component.html',
  styleUrls: ['./check-reservation.component.scss']
})
export class CheckReservationComponent implements OnInit {
  @Input() mode = 'check-in';
  @Output() onSubmit = new EventEmitter<{reservationId: string; email: string;}>();

  reservationForm: FormGroup;

  constructor(
    private formBuilder: FormBuilder,
    private guestService: GuestService,
    private router: Router,
    private elem: ElementRef
  ) {
    this.reservationForm = this.formBuilder.group({
      reservationId: '',
      email: ''
    });
  }

  ngOnInit(): void {
    this.focusInput();
  }

  submit(reservationRequest) {
    this.onSubmit.emit(reservationRequest);
    setTimeout(() => this.reservationForm.disable());
  }

  enableForm() {
    this.reservationForm.enable();
  }

  cancel() {
    this.router.navigate(['/guest']);
  }

  focusInput() {
    const reservationId = this.elem.nativeElement.querySelector('#reservationId');
    reservationId.focus();
  }
}
