import { Component, OnInit } from '@angular/core';
import { first } from 'rxjs/operators';
import { Guest } from 'src/app/rooming-calendar/core/reservation/guest';
import { CheckInService, GuestDetailsItem, GuestDetails } from '../../../services/check-in/checkin.service';


@Component({
  selector: 'app-check-in-form-complete',
  templateUrl: './form-complete.component.html',
  styleUrls: ['./form-complete.component.scss']
})
export class CheckInFormCompleteComponent implements OnInit {
  isViewable: boolean;
  reservationId: string;
  reservationName: string;
  guest: Guest;
  item: GuestDetailsItem;
  resDetail: GuestDetails;
  guests$ = this.checkInService.guests$;

  constructor(
    private checkInService: CheckInService,
  ) {
    this.checkInService.guest$.pipe(first()).subscribe(guest => {
      this.guest = guest;
    });
    this.checkInService.item$.pipe(first()).subscribe(item => {
      this.item = item;
    });
    this.checkInService.guestDetails$.pipe(first()).subscribe(details => {
      this.reservationId = details.reservationId;
    });
    this.checkInService.guestDetails$.pipe(first()).subscribe(details => {
      this.reservationName = details.reservationName;
    });
  }

  ngOnInit(): void {
  }

  clearGuest() {
    this.checkInService.clearGuest();
  }
}
