
import { AfterViewInit, ChangeDetectorRef, Component, Input, OnInit } from '@angular/core';
import { FormBuilder, FormGroup, Validators } from '@angular/forms';
import { GuestService } from '../../../services/guest/guest.service';

@Component({
  selector: 'app-guest-list-item',
  templateUrl: './guest-list-item.component.html',
  styleUrls: ['./guest-list-item.component.scss']
})
export class GuestListItemComponent implements OnInit {
  @Input() id;
  @Input() guest;

  placeHolders = {
    firstName: '',
    lastName: '',
    email: '',
  }

  itemForm: FormGroup;

  constructor(
    private cdr: ChangeDetectorRef,
    private formBuilder: FormBuilder,
  ) {
    this.itemForm = this.formBuilder.group({
      firstName: ['', [Validators.required]],
      lastName: ['', [Validators.required]],
      email: ['', [Validators.required, Validators.pattern(GuestService.emailPattern)]]
    });
  }

  ngOnInit(): void {
    this.update();

    if (this.guest.id && !this.guest.initialData) {
      this.guest.initialData = {
        firstName: this.guest.firstName,
        lastName: this.guest.lastName,
        email: this.guest.email,
      }
    }

    if (this.guest.initialData) {
      this.placeHolders['firstName'] = this.guest.initialData.firstName;
      this.placeHolders['lastName'] = this.guest.initialData.lastName;
      this.placeHolders['email'] = this.guest.initialData.email;
    }
  }

  update() {
    if (this.guest && this.guest.locked) {
      this.itemForm.disable();
    } else {
      this.itemForm.enable();
    }
    this.cdr.detectChanges();
  }

  clear() {
    this.itemForm.reset();
    this.itemForm.enable();
    this.guest.locked = false;
    this.guest.updated = true;

    this.itemForm.get('firstName').setValidators([]);
    this.itemForm.get('lastName').setValidators([]);
    this.itemForm.get('email').setValidators([Validators.pattern(GuestService.emailPattern)]);

    this.itemForm.get('firstName').setErrors(null);
    this.itemForm.get('lastName').setErrors(null);
    this.itemForm.get('email').setErrors(null);

    this.itemForm.updateValueAndValidity()
  }

  restore() {
    if (this.guest.initialData) {
      this.guest.firstName = this.guest.initialData.firstName;
      this.guest.lastName = this.guest.initialData.lastName;
      this.guest.email = this.guest.initialData.email;
      this.guest.locked = true;
      this.guest.updated = false;

      this.itemForm.get('firstName').setValidators([Validators.required]);
      this.itemForm.get('lastName').setValidators([Validators.required]);
      this.itemForm.get('email').setValidators([Validators.required, Validators.pattern(GuestService.emailPattern)]);
      this.itemForm.updateValueAndValidity()

      this.update();
    }
  }

  ngAfterViewInit() {
  }

  isValid() {
    if (this.guest.locked) {
      return true;
    } else {
      return this.itemForm.valid;
    }
  }

  isEmpty() {
    if (
      this.itemForm.get('firstName').value === '' &&
      this.itemForm.get('lastName').value === '' &&
      this.itemForm.get('email').value === ''
    ) {
      return true;
    } else {
      return false;
    }
  }
}
