import { Component, OnInit } from '@angular/core';
import { GuestSettings, GuestService } from '../../services/guest/guest.service';
import { PublicWindowService } from '../../services/public/public.service';


@Component({
  selector: 'app-guest-header',
  templateUrl: './guest-header.component.html',
  styleUrls: ['./guest-header.component.scss'],
  providers: [
    PublicWindowService
  ]
})

export class GuestHeaderComponent implements OnInit {
  guestSettings$ = this.guestService.guestSettings$

  constructor(
    private guestService: GuestService,
    private windowService: PublicWindowService
  ) {}
  
  ngOnInit(): void {}

  openEmail(address, subject) {
    if(!subject) {
      subject = "";
    }
    this.windowService.openLegacyPopup('email_form.php?email_address='
      /* rv_res_item_group_id    */ + address
      /* ac_accomm_room_id      */ + '&email_subject=' + subject,
    '', 1024, 550);
  }

}
