import { Component, Input, OnInit, Output } from '@angular/core';
import { EventEmitter } from '@angular/core';
import { Guest } from '../../services/check-in/checkin.service';
import { CheckInService } from '../../services/check-in/checkin.service';

@Component({
  selector: 'app-select-guest',
  templateUrl: './select-guest.component.html',
  styleUrls: ['./select-guest.component.scss']
})
export class SelectGuestComponent implements OnInit {
  @Input() guests: Guest[];
  @Output() onSelect = new EventEmitter();

  constructor(
    private checkInService: CheckInService,
  ) { }

  ngOnInit(): void {
  }

  selectGuest(guest) {
    this.onSelect.emit(guest);
  }
}
