import { Injectable } from '@angular/core';

@Injectable()
export class PublicWindowService {
  private openedWindows: Window[];

  constructor() {
    this.openedWindows = [];
    window.addEventListener('beforeunload', e => this.closeWindows(e));
  }

  closeWindows(e) {
    for (let w of this.openedWindows) {
      w.close();
    }
  }

  openLegacyPopup(url: string, name?: string, width?: number, height?: number): void {
    const legacyUrl = url;
    this.openPopup(legacyUrl, name, width, height);
  }

  openPopup(url: string, name?: string, width?: number, height?: number): void {
    if (!name) { name = ''; }
    if (!width) { width = 400; }
    if (!height) { height = 300; }

    const left = screen.availWidth / 2 - width / 2;
    const top = screen.availHeight / 2 - height / 2;
    const size = 'fullscreen=0,width=' + width + ',height=' + height + ',left=' + left + ',top=' + top;

    const windowRef = window.open(url, name, size);

    this.openedWindows.push(windowRef);
  }
}
