import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { MatButtonModule } from '@angular/material/button';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { MatDividerModule } from '@angular/material/divider';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatIconModule } from '@angular/material/icon';
import { MatInputModule } from '@angular/material/input';
import { MatProgressBarModule } from '@angular/material/progress-bar';
import { MatTooltipModule } from '@angular/material/tooltip';
import { ButtonContainerComponent } from './components/buttons/button-container/button-container.component';
import { GuestImageComponent } from './components/image/guestimage.component';
import { GuestHeaderComponent } from './components/header/guest-header.component';
import { ButtonComponent } from './components/buttons/button/button.component';
import { CheckReservationComponent } from './components/forms/check-reservation/check-reservation.component';
import { CheckInFormComponent } from './components/forms/check-in-form/check-in-form.component';
import { GuestListFormComponent } from './components/forms/guest-list-form/guest-list-form.component';
import { FormStepperComponent } from './components/forms/form-stepper/form-stepper.component';
import { CheckInFormCompleteComponent } from './components/forms/form-complete/form-complete.component';
import { GuestListCompleteComponent } from './components/forms/guest-list-form-complete/guest-list-form-complete.component';
import { FontAwesomeModule } from '@fortawesome/angular-fontawesome';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MAT_DATE_LOCALE } from '@angular/material/core';
import { MatProgressSpinnerModule } from '@angular/material/progress-spinner';
import { DragDropModule } from '@angular/cdk/drag-drop';
import { MatMomentDateModule } from '@angular/material-moment-adapter';
import { GuestListItemComponent } from './components/forms/guest-list-item/guest-list-item.component';
import { SelectGuestComponent } from './components/select-guest/select-guest.component';
import { SelectItemComponent } from './components/select-item/select-item.component';
import {MatMenuModule} from '@angular/material/menu';

@NgModule({
  declarations: [
    ButtonContainerComponent,
    ButtonComponent,
    GuestImageComponent,
    GuestHeaderComponent,
    CheckReservationComponent,
    CheckInFormComponent,
    FormStepperComponent,
    CheckInFormCompleteComponent,
    GuestListFormComponent,
    GuestListCompleteComponent,
    GuestListItemComponent,
    SelectGuestComponent,
    SelectItemComponent,
  ],
  imports: [
    CommonModule,
    MatButtonModule,
    MatIconModule,
    MatDividerModule,
    FontAwesomeModule,
    MatProgressBarModule,
    MatFormFieldModule,
    MatInputModule,
    MatCheckboxModule,
    MatTooltipModule,
    MatDatepickerModule,
    FormsModule,
    MatProgressSpinnerModule,
    DragDropModule,
    ReactiveFormsModule,
    MatMomentDateModule,
    MatMenuModule
  ],
  exports: [
    ButtonContainerComponent,
    ButtonComponent,
    GuestImageComponent,
    GuestHeaderComponent,
    CheckReservationComponent,
    CheckInFormComponent,
    FormStepperComponent,
    CheckInFormCompleteComponent,
    GuestListFormComponent,
    GuestListCompleteComponent,
    SelectGuestComponent,
    SelectItemComponent,
  ],
  providers: [
    { provide: MAT_DATE_LOCALE, useValue: 'en-GB' }
  ]
})
export class SharedGuestModule { }
