import { CommonModule } from '@angular/common';
import { BrowserModule } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { MatProgressSpinnerModule } from '@angular/material/progress-spinner';
import { MatButtonModule } from '@angular/material/button';
import { MatDialogModule } from '@angular/material/dialog';

import { SharedModule } from './header/shared/shared.module';
import { HeaderComponent } from './header/component';
import { ErrordialogComponent } from './header/errordialog/errordialog.component';
import { HttpClientModule } from '@angular/common/http';

@NgModule({
  declarations: [
    HeaderComponent,
    ErrordialogComponent
  ],
  imports: [
    CommonModule,
    SharedModule,
    BrowserModule,
    MatProgressSpinnerModule,
    MatDialogModule,
    MatButtonModule,
    HttpClientModule
  ],
  exports: [
    HeaderComponent
  ],
  entryComponents: [
    ErrordialogComponent
  ],
  providers: [],
  bootstrap: []
})
export class HeaderModule { }
