import { Component, ViewChild, ElementRef, ViewEncapsulation, Renderer2 } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { HttpClient } from '@angular/common/http';
import { LoaderService } from './shared/loader.service';
import { MatDialog } from '@angular/material/dialog'
import { ErrordialogComponent } from './errordialog/errordialog.component';

@Component({
  encapsulation: ViewEncapsulation.ShadowDom,
  selector: 'rr-main-header',
  providers: [ LoaderService ],
  templateUrl: './component.html',
  styleUrls: [
    './component.scss',
    '../../../../../../../Application/public/css/fonts.css',
    '../../../../../../../Application/public/css/sys.css',
    '../../../../../../../Application/public/css/quick_menu.css',
    '../../../../../../../Application/public/include/tooltipster/css/tooltipster.bundle.min.css',
    '../../../../../../../Application/public/include/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-shadow.min.css',
    '../../../../../../../Application/public/css/notifications.css',
    '../../../../../../../Application/public/css/select2.min.css',
    '../../../../../../../Application/public/css/tail.datetime-harx-light.min.css'
  ]
})
export class HeaderComponent {
  @ViewChild('rr-main-header', { read: ElementRef }) header: ElementRef;
  fetchedHtml: string = "";
  error: boolean = false;
  errorStatusText: string = "";
  errorMessage: string = "";
  errorText: string = "";

  constructor(
    private http : HttpClient,
    private loader: LoaderService,
    private renderer: Renderer2,
    private elementRef: ElementRef,
    public dialog: MatDialog
  ) { }

  ngOnInit() {
    this.loadFonts();
    // load the Enterprise header page on its own
    // 100%: full width
    // nojs: do not include javascript as it's loaded separately
    // nocss: do not include css as it's loaded separately
    // partial: don't include the top and bottom html/body tags
    var url = '/top_contents.php?100%+nojs+nocss+partial';
    this.http.get<string>(url, {responseType: 'text' as 'json'}).subscribe(
      response => {
        this.fetchedHtml = response;
      },
      error => {
        this.fetchedHtml = "<h1>An error ocurrred while loading the header. Please contact <a href='mailto:support@resrequest.com?Subject=ERROR Loading%20header' target='_top'>ResRequest Support (support@resrequest.com)</a>";
        this.error = true;
        this.errorStatusText = error.statusText;
        this.errorMessage = error.message;
        this.errorText = error.error;
      }
    );
    this.loadJavascript();
  }

  ngAfterViewInit(): void {
    this.loader.load(
      'js-top_contents',
    );
  }

  private loadJavascript(): void {
    this.loader.load(
      'js-jquery',
      'js-system',
      'js-ajax',
      'js-json2',
      'js-notifications',
      'js-events',
      'js-select2',
      'js-moment',
      'js-profiles',
      'js-rsclient',
      'js-jquery.autocomplete',
      'js-tooltipster',
      'js-taildatetime',
      'js-toolbar',
      'js-menu',
    );
  }

  private loadFonts(): void {
    // Has to be loaded twice due to shadow dom limitation
    // https://stackoverflow.com/questions/54546007/why-doesnt-font-awesome-work-in-my-shadow-dom
    this.loader.load(
      'css-fonts',
    );
  }

  private sleep(ms) {
    return new Promise(resolve => setTimeout(resolve, ms));
  }

  private viewError():void {
    const dialogRef = this.dialog.open(
      ErrordialogComponent,
      {
        data:  {
          errorStatusText: this.errorStatusText,
          errorMessage: this.errorMessage,
          errorText: this.errorText
        }
      }
    );
  }
}
