import { Injectable } from '@angular/core';
import { HttpClient } from '@angular/common/http';

interface Scripts {
  name: string;
  type: string;
  src: string;
  async: boolean;
  defer: boolean;
}

export const ScriptStore: Scripts[] = [
  // css
  { name: 'css-sys', type: 'link', src: '/resource/Resrequest/Application/public/css/sys.css', async: false, defer: false },
  { name: 'css-fonts', type: 'link', src: '/resource/Resrequest/Application/public/css/fonts.css', async: false, defer: false },
  { name: 'css-quick_menu', type: 'link', src: '/resource/Resrequest/Application/public/css/quick_menu.css', async: false, defer: false },
  { name: 'css-tooltipster', type: 'link', src: '/resource/Resrequest/Application/public/include/tooltipster/css/tooltipster.bundle.min.css', async: false, defer: false },
  { name: 'css-tooltipster-sideTip-shadow', type: 'link', src: '/resource/Resrequest/Application/public/include/tooltipster/css/plugins/tooltipster/sideTip/themes/tooltipster-sideTip-shadow.min.css', async: false, defer: false },
  { name: 'css-notifications', type: 'link', src: '/resource/Resrequest/Application/public/css/notifications.css', async: false, defer: false },
  { name: 'css-select2', type: 'link', src: '/resource/Resrequest/Application/public/css/select2.min.css', async: false, defer: false },
  { name: 'css-daterangepicker', type: 'link', src: '/resource/Resrequest/Application/public/css/daterangepicker.min.css', async: false, defer: false },
  { name: 'css-taildatetime', type: 'link', src: '/resource/Resrequest/Application/public/css/tail.datetime-harx-light.min.css', async: false, defer: false },
  // javascript
  { name: 'js-jquery', type: 'script', src: '/resource/Resrequest/Application/public/include/js/jquery.js', async: false, defer: false },
  { name: 'js-jquery.autocomplete', type: 'script', src: '/resource/Resrequest/Application/public/include/js/jquery.autocomplete.min.js', async: false, defer: false },
  { name: 'js-ajax', type: 'script', src: '/resource/Resrequest/Application/public/include/js/ajax.js', async: false, defer: false },
  { name: 'js-json2', type: 'script', src: '/resource/Resrequest/Application/public/include/js/json2.js', async: false, defer: false },
  { name: 'js-tooltipster', type: 'script', src: '/resource/Resrequest/Application/public/include/tooltipster/js/tooltipster.bundle.min.js', async: false, defer: false },
  { name: 'js-notifications', type: 'script', src: '/resource/Resrequest/Application/public/include/js/notifications.js', async: false, defer: false },
  { name: 'js-menu', type: 'script', src: '/resource/Resrequest/Application/public/include/js/menu.js', async: false, defer: false },
  { name: 'js-rsclient', type: 'script', src: '/resource/Resrequest/Application/public/include/js/rsClient.js', async: false, defer: false },
  { name: 'js-select2', type: 'script', src: '/resource/Resrequest/Application/public/include/js/select2.full.min.js', async: false, defer: false },
  { name: 'js-moment', type: 'script', src: '/resource/Resrequest/Application/public/include/js/moment.min.js', async: false, defer: false },
  { name: 'js-daterangepicker', type: 'script', src: '/resource/Resrequest/Application/public/include/js/daterangepicker.min.js', async: false, defer: false },
  { name: 'js-taildatetime', type: 'script', src: '/resource/Resrequest/Application/public/include/js/tail.datetime-full.js', async: false, defer: false },
  { name: 'js-profiles', type: 'script', src: '/resource/Resrequest/Application/public/include/js/profiles.js', async: false, defer: false },
  { name: 'js-system', type: 'script', src: '/resource/Resrequest/Application/public/include/js/system.js', async: false, defer: false },
  { name: 'js-events', type: 'script', src: '/resource/Resrequest/Application/public/include/js/events.js', async: false, defer: false },
  { name: 'js-toolbar', type: 'script', src: '/resource/Resrequest/Application/public/include/js/toolbar.js', async: false, defer: false },
  { name: 'js-top_contents', type: 'script', src: '/top_contents.php?+nojs+nocss+partial+top_contents.js', async: false, defer: false },
];

declare var document: any;

@Injectable()
export class LoaderService {

  public scripts: any = {};
  private elementName: string = "rr-main-header";
  private enterpriseVersion: string = "";

  constructor(private http : HttpClient) {
    //this.getVersion();
    ScriptStore.forEach((script: any) => {
      this.scripts[script.name] = {
        loaded: false,
        src: script.src,
        type: script.type,
        async: script.async,
        defer: script.defer
      };
    });
  }

  public load(...scripts: string[]) {
    const scriptsLoaded: any[] = [];
    scripts.forEach((script) => scriptsLoaded.push(this.loadScript(script)));
    return scriptsLoaded;
  }

  private loadScript(name: string) {
    if (typeof this.scripts[name] === 'undefined') {
      return new Error("ERROR: Could not find script '"+name+"'");
    }
    if (!this.scripts[name].loaded) {
      let script = document.createElement(this.scripts[name].type);
      if (this.scripts[name].type == "script") {
        script.type = 'text/javascript';
        script.src = this.scripts[name].src + "?" + this.enterpriseVersion;
        script.async = this.scripts[name].async;
        script.defer = this.scripts[name].defer;
      } else if (this.scripts[name].type == "link") {
        script.type = 'text/css';
        script.href = this.scripts[name].src + "?" + this.enterpriseVersion;
        script.rel = 'stylesheet';
      }
      if (script.readyState) {  //IE
        script.onreadystatechange = () => {
          if (script.readyState === "loaded" || script.readyState === "complete") {
            script.onreadystatechange = null;
            this.scripts[name].loaded = true;
          }
        };
      } else {  //Others
        script.onload = () => {
          this.scripts[name].loaded = true;
        };
      }
      script.onerror = (error: any) => console.log("ERROR: Could not load script "+"'"+name+"'. Error was '"+error+"'");
      if (this.elementName) {
        document.getElementsByTagName(this.elementName)[0].appendChild(script);
      } else {
        document.getElementsByTagName('head')[0].appendChild(script);
      }
    }
    return this.scripts[name];
  }

  private async getVersion(): Promise<any> {
    return await this.http
      .get<string>("/api/v1/ping", {responseType: 'json' as 'json'})
      .toPromise()
      .then(response => {
        this.enterpriseVersion = response["systemVersion"];
    });
  }
}
