import { Injectable } from '@angular/core';
import { RcmApiService } from 'resrequest-angular-common';
import { catchError, map } from 'rxjs/operators';
import { of } from 'rxjs';

@Injectable()
export class MinLOSService {
  getRulesUrl = '/api/v1/minlos/get_rule';
  addRuleUrl = '/api/v1/minlos/add_rule';
  deleteRuleUrl = '/api/v1/minlos/delete_rule';
  editRuleUrl = '/api/v1/minlos/edit_rule';


  runWorkflowUrl = '/api/v1/workflows/run_workflow';
  getWorkflowTriggersUrl = '/api/v1/workflows/get_workflow_trigger';

  constructor(private api: RcmApiService) { }

  public getRules(ruleIds: string[] = null): any {
    const request = {
      ids: ruleIds
    };
    return this.api.post(this.getRulesUrl, request).pipe(
      catchError(error => {
        console.error(error);
        return of(null);
      }),
      map(data => {
        data.rules.map(rule => {
          rule.applyToAllocations = rule.applyToAllocations == "0" ? false : true;
          return rule;
        });

        return data;
      })
    );
  }



  public addRule(
    description: string,
    ratePeriods: string[],
    rateTypes: string[],
    agents: string[],
    accommodationTypes: string[],
    minLos: number,
    lapseLeadNights: number,
    applyToAllocations: boolean,
    lastDayDeparture: boolean,
    tmpMinLosDays: {
      Sunday: boolean,
      Monday: boolean,
      Tuesday: boolean,
      Wednesday: boolean,
      Thursday: boolean,
      Friday: boolean,
      Saturday: boolean
    }
  ): any {
    let minLosDays = [];

    if (tmpMinLosDays.Sunday) {
      minLosDays.push(0);
    }
    if (tmpMinLosDays.Monday) {
      minLosDays.push(1);
    }
    if (tmpMinLosDays.Tuesday) {
      minLosDays.push(2);
    }
    if (tmpMinLosDays.Wednesday) {
      minLosDays.push(3);
    }
    if (tmpMinLosDays.Thursday) {
      minLosDays.push(4);
    }
    if (tmpMinLosDays.Friday) {
      minLosDays.push(5);
    }
    if (tmpMinLosDays.Saturday) {
      minLosDays.push(6);
    }

    const rule = {
      description,
      ratePeriods,
      rateTypes,
      agents,
      accommodationTypes,
      minLos,
      lapseLeadNights,
      applyToAllocations,
      lastDayDeparture,
      minLosDays
    };

    return this.api.post(this.addRuleUrl, rule).pipe(
      catchError(error => {
        console.error(error);
        return of(null);
      })
    );
  }

  public updateRule(
    id: string,
    description: string,
    ratePeriods: string[],
    rateTypes: string[],
    agents: string[],
    accommodationTypes: string[],
    minLos: number,
    lapseLeadNights: number,
    applyToAllocations: boolean,
    lastDayDeparture: boolean,
    tmpMinLosDays: {
      Sunday: boolean,
      Monday: boolean,
      Tuesday: boolean,
      Wednesday: boolean,
      Thursday: boolean,
      Friday: boolean,
      Saturday: boolean
    }
  ): any {
    let minLosDays = [];

    if (tmpMinLosDays.Sunday) {
      minLosDays.push(0);
    }
    if (tmpMinLosDays.Monday) {
      minLosDays.push(1);
    }
    if (tmpMinLosDays.Tuesday) {
      minLosDays.push(2);
    }
    if (tmpMinLosDays.Wednesday) {
      minLosDays.push(3);
    }
    if (tmpMinLosDays.Thursday) {
      minLosDays.push(4);
    }
    if (tmpMinLosDays.Friday) {
      minLosDays.push(5);
    }
    if (tmpMinLosDays.Saturday) {
      minLosDays.push(6);
    }

    const rule = {
      id,
      description,
      ratePeriods,
      rateTypes,
      agents,
      accommodationTypes,
      minLos,
      lapseLeadNights,
      applyToAllocations,
      lastDayDeparture,
      minLosDays
    };
    return this.api.post(this.editRuleUrl, rule).pipe(
      catchError(error => {
        console.error(error);
        return of(null);
      })
    );
  }

  public deleteRule(
    ruleId: string
  ): any {
    const request = {
      id: ruleId
    };
    return this.api.post(this.deleteRuleUrl, request).pipe(
      catchError(error => {
        console.error(error);
        return of(null);
      })
    );
  }
}
