import { Injectable} from '@angular/core';
import { RcmApiService } from 'resrequest-angular-common';
import { catchError } from 'rxjs/operators';
import { of } from 'rxjs';

@Injectable()
export class WorkflowService {
    getWorkflowsUrl = '/api/v1/workflows/get_workflow';
    addWorkflowUrl = '/api/v1/workflows/add_workflow';
    deleteWorkflowUrl = '/api/v1/workflows/delete_workflow';
    editWorkflowUrl = '/api/v1/workflows/edit_workflow';
    runWorkflowUrl = '/api/v1/workflows/run_workflow';
    getWorkflowTriggersUrl = '/api/v1/workflows/get_workflow_trigger';

    constructor(private api: RcmApiService) {}

    public getWorkflows(_awWorkflowId: string = null): any {
        const request = {
            awWorkflowId: _awWorkflowId
        };
        return this.api.post(this.getWorkflowsUrl, request).pipe(
          catchError(error => {
            console.error(error);
            return of(null);
          })
        );
    }

    public addWorkflow(
       _awWorkflowName: string,
       _awWorkflowDescription: string,
       _awWorkflowTypeInd: number,
       _awWorkflowInactiveYn: number,
       _awWorkflowScheduleDays: number,
       _awWorkflowBeforeAfterInd: number,
       _awWorkflowTriggerId: number,
       _awWorkflowTime: string,
       _awWorkflowConfig: any
    ): any {
      _awWorkflowInactiveYn = _awWorkflowInactiveYn ? 0 : 1;
      const workflow = {
        awWorkflowName: _awWorkflowName,
        awWorkflowDescription: _awWorkflowDescription,
        awWorkflowTypeInd: _awWorkflowTypeInd,
        awWorkflowInactiveYn: _awWorkflowInactiveYn,
        awWorkflowScheduleDays: _awWorkflowScheduleDays,
        awWorkflowBeforeAfterInd: _awWorkflowBeforeAfterInd,
        awWorkflowTriggerId: _awWorkflowTriggerId,
        awWorkflowTime: _awWorkflowTime,
        awWorkflowConfig: _awWorkflowConfig
      };
      return this.api.post(this.addWorkflowUrl, workflow).pipe(
        catchError(error => {
          console.error(error);
          return of(null);
        })
      );
    }

    public updateWorkflow(
       _awWorkflowId: string,
       _awWorkflowName: string,
       _awWorkflowDescription: string,
       _awWorkflowTypeInd: number,
       _awWorkflowInactiveYn: number,
       _awWorkflowScheduleDays: number,
       _awWorkflowBeforeAfterInd: number,
       _awWorkflowTriggerId: number,
       _awWorkflowTime: string,
       _awWorkflowConfig: any
    ): any {
      _awWorkflowInactiveYn = _awWorkflowInactiveYn ? 0 : 1;
      const workflow = {
        awWorkflowId: _awWorkflowId,
        awWorkflowName: _awWorkflowName,
        awWorkflowDescription: _awWorkflowDescription,
        awWorkflowTypeInd: _awWorkflowTypeInd,
        awWorkflowInactiveYn: _awWorkflowInactiveYn,
        awWorkflowScheduleDays: _awWorkflowScheduleDays,
        awWorkflowBeforeAfterInd: _awWorkflowBeforeAfterInd,
        awWorkflowTriggerId: _awWorkflowTriggerId,
        awWorkflowTime: _awWorkflowTime,
        awWorkflowConfig: _awWorkflowConfig
      };
      return this.api.put(this.editWorkflowUrl, workflow).pipe(
        catchError(error => {
          console.error(error);
          return of(null);
        })
      );
    }

    public deleteWorkflow(
       _awWorkflowId: string
    ): any {
      const workflow = {
        awWorkflowId: _awWorkflowId
      };
      return this.api.post(this.deleteWorkflowUrl, workflow).pipe(
        catchError(error => {
          console.error(error);
          return of(null);
        })
      );
    }

    public runWorkflow(
       _awWorkflowId: string
    ): any {
      const workflow = {
        awWorkflowId: _awWorkflowId
      };
      return this.api.post(this.runWorkflowUrl, workflow).pipe(
        catchError(error => {
          console.error(error);
          return of(null);
        })
      );
    }

    public getWorkflowTriggers(_awWorkflowTriggerId: string = null): any {
        const request = {
            awWorkflowTriggerId: _awWorkflowTriggerId
        };
        return this.api.post(this.getWorkflowTriggersUrl, request).pipe(
          catchError(error => {
            console.error(error);
            return of(null);
          })
        );
    }
}
