import { NgModule } from '@angular/core';
import { Routes, RouterModule } from '@angular/router';

const routes: Routes = [
  { path: 'dashboard', loadChildren: () => import('./dashboard/dashboard.module').then(m => m.DashboardModule) },
  { path: 'rooming', loadChildren: () => import('./rooming-calendar/rooming-calendar.module').then(m => m.RoomingCalendarModule) },
  { path: 'admin/setup/workflows', loadChildren: () => import('./admin/setup/setup.module').then(m => m.SetupModule)}, 
  { path: 'admin/rates/minlos', loadChildren: () => import('./admin/rates/rates.module').then(m => m.RatesModule)}, 
  { path: '**', redirectTo: '/dashboard' }
];

@NgModule({
  imports: [RouterModule.forRoot(routes)],
  exports: [RouterModule]
})
export class AppRoutingModule { }
