import { Component } from '@angular/core';
import { Observable } from 'rxjs';
import { Sidebar } from './shared/services/sidebar/sidebar';
import { SidebarService } from './shared/services/sidebar/sidebar.service';
import { AuthorisationService } from './shared/services/authorisation/authorisation.service';
import { InfoService } from './shared/services/info/info.service';
import { Location } from '@angular/common';

@Component({
  selector: 'app-root',
  templateUrl: './app.component.html',
  styleUrls: ['./app.component.scss']
})

export class AppComponent {
  showSidebar$: Observable<boolean>;
  sidebar$: Observable<Sidebar>;
  hasBackdrop$: Observable<boolean>;
  autoFocus$: Observable<boolean>;

  constructor(
    private sidebarService: SidebarService,
    private authorisationService: AuthorisationService,   // Required to fetch auth on startup
    private infoService: InfoService,    // Required to fetch user info on startup
    private location: Location
  ) {
    this.showSidebar$ = sidebarService.showSidebar$;
    this.sidebar$ = sidebarService.sidebar$;
    this.hasBackdrop$ = sidebarService.hasBackdrop$;
    this.autoFocus$ = sidebarService.autoFocus$;
  }

  closeSidebar(): void {
    this.sidebarService.close();
  }

  /**
   * Check if the path contains the specified route
   *
   */
  hasRoute(route: string) {
    return this.location.path().startsWith(route);
  }
}
