import { BrowserModule, Title } from '@angular/platform-browser';
import { NgModule } from '@angular/core';
import { BrowserAnimationsModule } from '@angular/platform-browser/animations';
import { HeaderModule } from '../../projects/header/src/app/header.module';
import { AppComponent } from './app.component';
import { AppRoutingModule } from './app-routing.module';
import { ResrequestCommonModule } from 'resrequest-angular-common';
import { MatSidenavModule } from '@angular/material/sidenav';
import { SidebarService } from './shared/services/sidebar/sidebar.service';
import { FontAwesomeModule} from '@fortawesome/angular-fontawesome';
import { AuthorisationService } from './shared/services/authorisation/authorisation.service';
import { InfoService } from './shared/services/info/info.service';
// Imported here due to Angular 8 compat bug https://github.com/Agranom/ngx-material-timepicker/issues/219
import { NgxMaterialTimepickerModule } from 'ngx-material-timepicker';

@NgModule({
  declarations: [
    AppComponent
  ],
  imports: [
    BrowserModule,
    BrowserAnimationsModule,
    ResrequestCommonModule,
    AppRoutingModule,
    HeaderModule,
    MatSidenavModule,
    FontAwesomeModule,
    NgxMaterialTimepickerModule,
  ],
  providers: [
    Title,
    SidebarService,
    AuthorisationService,
    InfoService
  ],
  bootstrap: [ AppComponent ]
})
export class AppModule {
}
