import { NgModule } from '@angular/core';
import { CommonModule } from '@angular/common';
import { DashboardComponent } from './dashboard.component';
import { DashboardRoutingModule } from './dashboard-routing.module';
import { MatTabsModule } from '@angular/material/tabs';
import { ChartModule } from '../../../projects/charts/src/app/app.module';
import { TourismTodayComponent } from './tourism-today/tourism-today.component';
import { AboutTourismTodayComponent } from './tourism-today/about-tourism-today/about-tourism-today.component';
import { MatDialogModule } from '@angular/material/dialog';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { MatButtonToggleModule } from '@angular/material/button-toggle';
import { FormsModule } from '@angular/forms';
import { ResvegaService } from './tourism-today/resvega.service';
import { DashboardService } from './dashboard.service';
import { MatProgressSpinnerModule } from '@angular/material/progress-spinner';

@NgModule({
  declarations: [DashboardComponent, TourismTodayComponent, AboutTourismTodayComponent],
  imports: [
    CommonModule,
    DashboardRoutingModule,
    ChartModule.forRoot(),
    MatTabsModule,
    MatButtonToggleModule,
    FormsModule,
    MatCheckboxModule,
    MatDialogModule,
    MatProgressSpinnerModule,
  ],
  providers: [
    ResvegaService,
    DashboardService
  ]
})
export class DashboardModule { }
