import { Component, OnInit, ChangeDetectionStrategy } from '@angular/core';
import { CalendarService } from '../../services/calendar/calendar.service';
import { Observable } from 'rxjs';
import { CalendarDate } from '../../core/calendar/calendar-date';
import { CalendarGrid } from '../../core/calendar/calendar-grid';

@Component({
  selector: 'app-calendar-header',
  templateUrl: './calendar-header.component.html',
  styleUrls: ['./calendar-header.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class CalendarHeaderComponent implements OnInit {
  private calendarGrid: CalendarGrid;

  constructor(public calendar: CalendarService) {
    this.calendarGrid = new CalendarGrid(calendar);
  }

  ngOnInit() {
  }

  /**
   * Determine the grid column property given a calendar date
   * and optional span.
   * @param date The date to get the column for.
   */
  gridColumnForDateHeader(date: CalendarDate): Observable<string> {
    return this.calendarGrid.gridStartColumnByDate(date, 2);
  }

  /**
   * The grid column property for the nav next buttons.
   */
  gridColumnForNavNext(): Observable<string> {
    return this.calendarGrid.gridColumnForNavNext(2);
  }
}
