import { Component, HostListener, OnInit, ChangeDetectionStrategy, OnDestroy, AfterViewChecked } from '@angular/core';
import { CalendarService } from '../services/calendar/calendar.service';
import { Observable } from 'rxjs';
import { SubSink } from 'subsink';
import { ScrollPosition } from '../core/calendar/scroll-position';
import { first } from 'rxjs/operators';

@Component({
  selector: 'app-calendar',
  templateUrl: './calendar.component.html',
  styleUrls: ['./calendar.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class CalendarComponent implements AfterViewChecked, OnDestroy {
  scrollShow: boolean;
  topPosToStartShowing = 20;
  loading$: Observable<boolean>;
  conflictsDismissed$ = this.calendar.conflictsDismissed$;
  conflicts$ = this.calendar.conflicts$;
  private subsink: SubSink;
  private scrolled: boolean;

  constructor(public calendar: CalendarService) {
    this.loading$ = calendar.loading$;
    this.subsink = new SubSink();
    this.scrolled = false;
  }

  @HostListener('window:scroll')
  checkScroll() {
    const scrollY = window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop || 0;
    const scrollX = window.scrollX;

    if (scrollY >= this.topPosToStartShowing) {
      this.scrollShow = true;
    } else {
      this.scrollShow = false;
    }

    this.calendar.onCalendarScroll({xScroll: scrollX, yScroll: scrollY});
  }

  // TODO: Cross browsing
  gotoTop() {
    window.scroll({
      top: 0,
      left: 0,
      behavior: 'smooth'
    });
  }

  ngAfterViewChecked() {
    if (!this.scrolled) {
      this.scrolled = true;
      this.subsink.sink = this.calendar.calendarScrolled$.pipe(first()).subscribe(scrollPosition => {
        this.scrollToPosition(scrollPosition);
      });
    }
  }

  ngOnDestroy() {
    this.subsink.unsubscribe();
  }

  private scrollToPosition(scrollPosition: ScrollPosition): void {
    window.scrollTo(scrollPosition.xScroll, scrollPosition.yScroll);
  }
}
