import { Component, OnInit, Input, HostBinding, ChangeDetectionStrategy } from '@angular/core';
import { CalendarDate } from '../../core/calendar/calendar-date';

@Component({
  selector: 'app-date-cell',
  templateUrl: './date-cell.component.html',
  styleUrls: ['./date-cell.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class DateCellComponent implements OnInit {
  @Input() date: CalendarDate;

  @HostBinding('class.weekend') get isWeekend() {
    return this.date.isWeekend;
  }

  constructor() { }

  ngOnInit() {
  }

}
