import { Component, OnInit, HostListener, ViewChild, TemplateRef } from '@angular/core';
import { Sidebar } from 'src/app/shared/services/sidebar/sidebar';
import { SidebarService } from 'src/app/shared/services/sidebar/sidebar.service';
import { CalendarService } from '../../services/calendar/calendar.service';
import { first } from 'rxjs/operators';
import { ReservationPortalService } from '../../services/reservation-portal/reservation-portal.service';
import { LegacyService } from '../../services/legacy/legacy.service';

@Component({
  selector: 'app-hotkeys',
  templateUrl: './hotkeys.component.html',
  styleUrls: ['./hotkeys.component.scss'],
  providers: [ LegacyService ]
})
export class HotkeysComponent implements OnInit {
  @ViewChild('portalTemplate') portalTemplate: TemplateRef<any>;
  startPortal: string;

  constructor(
    private sidebarService: SidebarService,
    private calendarService: CalendarService,
    private reservationPortalService: ReservationPortalService,
    private legacyService: LegacyService
  ) {
    this.startPortal = 'itinerary';
  }

  @HostListener('window:keydown', ['$event'])
  async keyEvent(event: KeyboardEvent) {
    const activeItem = await this.calendarService.activeItem$.pipe(first()).toPromise();

    if (event.key === "F4" && !event.ctrlKey && !event.altKey) {
      event.preventDefault();
      this.startPortal = 'check-in';

      if (activeItem) {
        this.openReservation();
      }
    }

    if (event.key === "F5" && !event.ctrlKey && !event.altKey) {
      // Go to Manage Guests.
      event.preventDefault();

      if (activeItem) {
        this.legacyService.addGuests(activeItem.data);
      }
    }

    if (event.key === "F6" && !event.ctrlKey && !event.altKey) {
      // Go to Add Extras.
      event.preventDefault();
      this.startPortal = 'add-extras';

      if (activeItem) {
        this.openReservation();
      }
    }

    if (event.key === "F7" && !event.ctrlKey && !event.altKey) {
      // Go to Manage Billing.
      event.preventDefault();
      this.startPortal = 'manage-billing';

      if (activeItem) {
        this.openReservation();
      }
    }

    if (event.key === "F8" && !event.ctrlKey && !event.altKey) {
      // Go to reservation.
      event.preventDefault();

      if (activeItem) {
        const reservationId = activeItem.data.reservationId;
        const url = `/reservation.php?2+${reservationId}`;
        location.href = url;
      }
    }
  }

  ngOnInit(): void {
  }

  openReservation(): void {
    this.reservationPortalService.onOpenPortal(this.startPortal);
    const sidebar: Sidebar = {
      id: 'rooming-calendar-reservation',
      template: this.portalTemplate
    };
    this.sidebarService.showSidebar(sidebar);
  }
}
