import { Component, OnInit, Input } from '@angular/core';
import ol from 'openlayers';

@Component({
  selector: 'app-map',
  templateUrl: './map.component.html',
  styleUrls: ['./map.component.scss']
})
export class MapComponent implements OnInit {
  @Input() longitude: number = 0;
  @Input() latitude: number = 0;

  constructor() { }

  ngOnInit(): void {
    this.showMap()
  }

  private showMap():void {
    const attribution = new ol.control.Attribution({
      collapsible: false
    });

    new ol.Map({
      controls: ol.control.defaults({attribution: false}).extend([attribution]),
      layers: [
        new ol.layer.Tile({
          source: new ol.source.OSM()
        }),
        new ol.layer.Vector({
          source: new ol.source.Vector({
            features: [
              new ol.Feature({
                geometry: new ol.geom.Point(ol.proj.fromLonLat([this.longitude, this.latitude]))
              })
            ]
          }),
          style: new ol.style.Style({
            image: new ol.style.Icon({
              anchor: [0.5, 0.5],
              size: [29, 94],
              scale: 1,
              src: 'ui/assets/images/mapmarker.png'
            })
          })
        })
      ],
      target: 'map',
      view: new ol.View({
        center: ol.proj.fromLonLat([this.longitude, this.latitude]),
        maxZoom: 18,
        zoom: 5
      })
    });
  }
}