import { Component, OnInit, Input, Output, EventEmitter, HostListener } from '@angular/core';
import { trigger, transition, style, animate } from "@angular/animations";
import { faFacebookSquare, faTwitterSquare, faPinterestSquare, faGooglePlusSquare, faLinkedin, faTripadvisor } from '@fortawesome/free-brands-svg-icons';
import { SidebarService } from 'src/app/shared/services/sidebar/sidebar.service';
import { PropInfoService } from '../../services/prop-info/prop-info.service';
import { PortalService } from 'src/app/shared/components/portal/portal.service';

@Component({
  selector: 'app-prop-info-sidenav',
  templateUrl: './prop-info-sidenav.component.html',
  styleUrls: ['./prop-info-sidenav.component.scss'],
  animations: [
    trigger('carouselAnimation', [
      transition('void => *', [
        style({ opacity: 0 }),
        animate('300ms', style({ opacity: 1 }))
      ]),
      transition('* => void', [
        animate('300ms', style({ opacity: 0 }))
      ])
    ])
  ]
})
export class PropInfoSidenavComponent implements OnInit {

  @Input() propId: string;
  @Input() accommId: string;
  infoProp: any;
  infoAccomm: any;
  public slides = [];
  currentSlide = 0;
  carouselWidth: number = 340;
  mapWidth: number = 231;
  mapLeftMargin: number = 0;
  mapFloat: any;
  showCarousel: boolean = false;
  showMap: boolean = false;
  roomDetailsWidth: number = 231;
  roomDetailsLeftMargin: number = 0;
  showRoomDetails: boolean = false;
  socialLinks: boolean = false;
  public links = [];
  telNr: boolean = false;
  propEmail: boolean = false;
  propWebsite: boolean = false;
  webLink : any;
  @Input() longitude: number = 0;
  @Input() latitude: number = 0;

  faFacebookSquare = faFacebookSquare;
  faTwitterSquare = faTwitterSquare;
  faPinterestSquare = faPinterestSquare;
  faGooglePlusSquare = faGooglePlusSquare;
  faLinkedin = faLinkedin;
  faTripadvisor = faTripadvisor;

  constructor(
    private sidebarService: SidebarService,
    private propInfoService: PropInfoService,
    private portalService: PortalService
  ) { }

  ngOnInit(): void {
    this.portalService.onShowLoading(true);
    this.resetData();
  }

  close(): void {
    this.sidebarService.close();
  }

  private resetData(): void {
    delete this.infoProp;
    delete this.infoAccomm;
    this.slides = [];
    this.currentSlide = 0;
    this.carouselWidth = 340;
    this.mapWidth = 231;
    this.mapLeftMargin = 0;
    this.showCarousel = false;
    this.showMap = false;
    this.roomDetailsWidth = 231;
    this.roomDetailsLeftMargin = 0;
    this.showRoomDetails = false;
    this.longitude = 0;
    this.latitude = 0;
    this.fetchData();
    this.socialLinks = false;
    this.links = [];
    this.telNr = false;
    this.propEmail = false;
    this.propWebsite = false;
  }

  public fetchData(): void {
    if (this.propId) this.fetchProp();
    if (this.accommId) this.fetchAccomm();
  }

  public fetchProp(): void {
    this.propInfoService.getPropInfo(this.propId, true)
    .subscribe(response => {
      this.infoProp = response[0];
      for (let i in this.infoProp.prBusinessImages) {
        this.slides.push({ src: this.infoProp.prBusinessImages[i].prBusImageFilename });
      }
      var lat = Number(this.infoProp.prBusinessGpsCoords.prBusPropLatitude);
      var lon = Number(this.infoProp.prBusinessGpsCoords.prBusPropLongitude);
      if (!isNaN(lat) && !isNaN(lon)) {
        this.latitude = lat;
        this.longitude = lon;
        this.showMap = true;
      }
      if (this.infoProp.prBusinessSocialLinks != 0) {
        this.socialLinks = true;
        for (let socialLink of this.infoProp.prBusinessSocialLinks) {
          let socialIcon;
          switch (socialLink.prSocialLabel) {
            case "Facebook":
              socialIcon = faFacebookSquare;
              break;
            case "Twitter":
              socialIcon = faTwitterSquare;
              break;
            case "Pinterest":
              socialIcon = faPinterestSquare;
              break;
            case "Google+":
              socialIcon = faGooglePlusSquare;
              break;
            case "LinkedIn":
              socialIcon = faLinkedin;
              break;
            case "TripAdvisor":
              socialIcon = faTripadvisor;
              break;
            default: ;
          }
          this.links.push({
            icon: socialIcon,
            href: this.formatLink(socialLink.prBusSocialData),
            target: '_blank'
          });
        }
      }
      else {
        this.socialLinks = false;
      }
      if (this.infoProp.prPhoneNumber != 0) {
        this.telNr = true;
      }
      else {
        this.telNr = false;
      }
      if (this.infoProp.prEmail != 0) {
        this.propEmail = true;
      }
      else {
        this.propEmail = false;
      }
      if (this.infoProp.prWebAddr != 0) {
        this.propWebsite = true;
        this.webLink = this.formatLink(this.infoProp.prWebAddr);
      }
      else {
        this.propWebsite = false;
      }
      this.showCarousel = this.slides.length === 0 ? false : true;
      if (this.showCarousel && this.showMap) {
        this.carouselWidth = 290;
        this.mapWidth = 200;
        this.mapFloat = "right";
        this.mapLeftMargin = 5;
      }
      if (this.showCarousel && !this.showMap) {
        this.carouselWidth = 510;
      }
      if (!this.showCarousel && this.showMap) {
        this.mapWidth = 510;
        this.mapFloat = "";
      }
      this.portalService.onShowLoading(false);
    });
  }

  public fetchAccomm(): void {
    this.propInfoService.getPropInfo(this.accommId, false)
    .subscribe(response => {
      this.infoAccomm = response[0].acAccommType[0];
      this.infoAccomm.propName = response[0].prNameLast;
      for (let i in this.infoAccomm.acAccommImages) {
        this.slides.push({ src: this.infoAccomm.acAccommImages[i].acAccommImageFilename });
      }

      this.showCarousel = this.slides.length === 0 ? false : true;
      this.showRoomDetails = true;
      if (this.showCarousel) {
        this.carouselWidth = 315;
        this.roomDetailsWidth = 215;
        this.roomDetailsLeftMargin = 5;
      } else {
        this.roomDetailsWidth = 510;
      }
        this.portalService.onShowLoading(false);
    });
  }

  onPreviousClick() {
    const previous = this.currentSlide - 1;
    this.currentSlide = previous < 0 ? this.slides.length - 1 : previous;
  }

  onNextClick() {
    const next = this.currentSlide + 1;
    this.currentSlide = next === this.slides.length ? 0 : next;
  }

  selectSlide(slideNumber: number) {
    this.currentSlide = slideNumber;
  }

  formatLink(link: string): string {
    if (
      link.startsWith('http://')
      || link.startsWith('https://')
    ) {
      return link;
    } else {
      return 'https://' + link;
    }
  }
}
