import { Component, OnInit, Input, ChangeDetectionStrategy, ViewChild, TemplateRef } from '@angular/core';
import { Room } from '../../core/room/room';
import { CalendarService } from '../../services/calendar/calendar.service';
import { SidebarService } from 'src/app/shared/services/sidebar/sidebar.service';
import { Sidebar } from 'src/app/shared/services/sidebar/sidebar';

@Component({
  selector: 'app-room-header',
  templateUrl: './room-header.component.html',
  styleUrls: ['./room-header.component.scss'],
  changeDetection: ChangeDetectionStrategy.OnPush
})
export class RoomHeaderComponent implements OnInit {
  @Input() room: Room;
  @Input() display: 'room' | 'accommodation';
  @ViewChild('propInfoSidenav') propInfoSidenav: TemplateRef<any>;
  accommId: string;
  propSideNavtitle: string;

  constructor(public calendar: CalendarService, private sidebarService: SidebarService) {
    this.display = 'room';
  }

  ngOnInit() {
  }

  public toggleAccommInfoSidenav(id: string, title: string): void {
    this.accommId = id;
    this.propSideNavtitle = title;
    const sidebar: Sidebar = {
      id: 'prop-info-sidenav',
      template: this.propInfoSidenav
    };
    this.sidebarService.showSidebar(sidebar);
  }

}
