import { BlockItem } from '../room/block-item';
import { CalendarIntersection } from './calendar-intersection';

export interface CalendarBlockItem {
  /**
   * The id of the block item.
   */
  id: string;

  /**
   * The block item.
   */
  data: BlockItem;

  /**
   * The intersection on the calendar.
   */
  intersection: CalendarIntersection;

  /**
   * Where the item intersects the extended calendar.
   */
  extendedIntersection: CalendarIntersection;

  /**
   * The property that this block belongs to.
   */
  propertyId: string;

  /**
   * The room id that the block belongs to.
   */
  roomId: string;
}
